
/************************************************************************
 *																								*
 *		Z80 Disassembler - Copyright (C) 1996 by									*
 *		Jeffery L. Post																	*
 *		22726 Benner Ave.																	*
 *		Torrance, CA  90505																*
 *																								*
 *		DZ80.H - Header File																*
 *																								*
 *		Version 2.0 - 08/18/96															*
 *																								*
 *	This program is free software; you can redistribute it and/or modify	*
 *	it under the terms of the GNU General Public License as published by	*
 *	the Free Software Foundation; either version 2 of the License, or		*
 *	(at your option) any later version.												*
 *																								*
 *	This program is distributed in the hope that it will be useful,		*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of			*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *	GNU General Public License for more details.									*
 *																								*
 *	You should have received a copy of the GNU General Public License		*
 *	along with this program; if not, write to the Free Software				*
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.				*
 *																								*
 ************************************************************************/

#define	MSDOS		/* Uncomment this for machines with segmented CPU
							architectures. For intelligently designed CPUs,
							we can use malloc instead of farmalloc for 64K
							byte arrays. */

/*#define	LINUX*/		/* Linux has no stricmp library function, must use
							strcasecmp instead. */

/*-----------------------------------------------------------------------

  Command line options:

	D - Generate comment field with address and data values.

	B - Force binary source file.

	H - Force hex source file.

	S - Change 'db' and 'dw' strings to 'defb' and 'defw'.

	X - Add hexadecimal constant to program addresses.

-------------------------------------------------------------------------

  Control codes allowed in the CTL file:

	A - Address			Specifies that the word entry is the address of
							something for which a label should be generated.

	B - Byte binary	Eight bit binary data.

	C - Code				Executable code.

	I - Ignore			Treat as uninitialized space. Will not be dis-
							assembled as code or anything else.

	L - Label			Generate a label for an address.

	S - Symbol			Generate a symbol for a value.

	T - Text				ASCII text.

	W - Word binary	Sixteen bit binary data.

	The difference between labels and symbols is that a label refers
	to a referenced address, whereas a symbol may be used for 8 or 16
	bit immediate data. For some opcodes (eg: ld hl,#xx), the label
	table will be searched first and, if the value is not found, the
	symbol table will be searched.

-------------------------------------------------------------------------

  Exit codes:

	0 - No error (good disassembly)

	1 - Insufficient memory

	2 - File error (source file not found, or disk full)

	3 - Error in control file

-------------------------------------------------------------------------

	Definition of pflg bits:	pflg = 0xff if not initialized.
										pflg = 0 when initialized by input file.

	bit 7		set if uninitialized space.
	bit 6		address data
	bit 5		word binary data
	bit 4		byte binary data
	bit 3		clear if address is referenced (see bit 0)
	bit 2		ascii text
	bit 1		set if split opcode
	bit 0		set if address is referenced (see bit 3)

	Two bits (3 and 0) are needed to flag a referenced address because
		such a reference could be to initialized or uninitialized code
		space. If we used a single bit, we could not distinguish between
		a reference and uninitialized space. Bit 3 set with bit 0 clear
		indicates that the control file has specified this area as code.

-------------------------------------------------------------------------

	Definition of option table bits:

	bit 7		unconditional transfer instruction (jp, ret, etc)
	bit 6		special processing (cb, dd, ed, fd opcodes)
	bit 5		relative addressing (jr, djnz)
	bit 4		direct reference (jp or call)
	bit 3		parenthesized address
	bit 2		immediate data
	bit 1		3 byte instruction
	bit 0		2 byte instruction

	option table entry = 0 if single byte opcode with no options.

-------------------------------------------------------------------------*/

#define	VERNO		2
#define	REVNO		0

#define	byte		unsigned char
#define	word		unsigned short

#define	TSTOP		32
#define	ASTOP		56								/* ascii stop */
#define	XSTOP		49								/* hex stop */

#define	PMEMSIZE	((unsigned long) 65536)		/* code space */

#define	EITHERFILE	0
#define	HEXFILE		1
#define	BINFILE		2

#define	GOOD_EXIT	0
#define	MEM_ERROR	1
#define	FILE_ERROR	2
#define	USER_ERROR	3

#define	SYMBOL		0
#define	LABEL			1

#define	ASCLINE		32		/* max length of ascii defb line		*/
#define	ASCLIMIT		512	/* size of ascii buffer					*/
#define	BYTELINE		8		/* max length of binary defb line	*/
#define	BYTELIMIT	512	/* size of byte binary buffer			*/
#define	WORDLINE		6		/* max length of defw line				*/
#define	WORDLIMIT	512	/* size of word binary buffer			*/
#define	NO_DATA		0xff	/* pmem uninitialized value			*/

/* opttbl bits: */

#define	OPT_XFER		0x80	/* unconditional transfer				*/
#define	OPT_SPEC		0x40	/* special codes (cd, dd, ed, fd)	*/
#define	OPT_REL		0x20	/* relative addressing					*/
#define	OPT_DIR		0x10	/* direct addressing (jp, call)		*/
#define	OPT_PAR		0x08	/* parenthesized address				*/
#define	OPT_IMM		0x04	/* immediate data							*/
#define	OPT_3			0x02	/* 3 byte instruction					*/
#define	OPT_2			0x01	/* 2 byte instruction					*/
#define	OPT_NONE		0x00	/* single byte, no options				*/

#define	OPT_SIZE				(OPT_2 | OPT_3)
#define	OPT_IMM2				(OPT_IMM | OPT_2)
#define	OPT_PAR2				(OPT_PAR | OPT_2)
#define	OPT_DIR_IMM3		(OPT_DIR | OPT_IMM | OPT_3)
#define	OPT_PAR_IMM3		(OPT_PAR | OPT_DIR_IMM3)
#define	OPT_REL2				(OPT_REL | OPT_2)
#define	OPT_SPEC2			(OPT_SPEC | OPT_2)

/* ED option bits: */

#define	OPT_ED_2			0x01	/* 2 byte, entry in edtbl				*/
#define	OPT_ED_STORE	0x03	/* write 16 bit register to memory	*/
#define	OPT_ED_LD_BC	0x13	/* load bc from memory					*/
#define	OPT_ED_LD_DE	0x23	/* load de from memory					*/
#define	OPT_ED_LD_SP	0x33	/* load sp from memory					*/
#define	OPT_ED_RET		0x81	/* retn or reti							*/

/* DD and FD option bits: */

#define	OPT_DD_2			0x01	/* 2 byte, entry in dd1tbl				*/
#define	OPT_DD_LOAD		0x02	/* 3 byte loads							*/
#define	OPT_DD_DIR		0x03	/* 4 byte direct addressing			*/
#define	OPT_DD_ARTH		0x06	/* 3 byte arithmetic codes				*/
#define	OPT_DD_CB		0x07	/* 4 byte dd/fd cb codes				*/

/* pflg bits: */

#define	PF_INIT		0xff	/* initial value					*/
#define	PF_DATA		0x00	/* data valid from file			*/
#define	PF_NOINIT	0x80	/* set if uninitialized space	*/
#define	PF_ADRS		0x40	/* address data					*/
#define	PF_WORD		0x20	/* word binary data				*/
#define	PF_BYTE		0x10	/* byte binary data				*/
#define	PF_CLREF		0x08	/* clear if referenced			*/
#define	PF_ASCII		0x04	/* ascii text						*/
#define	PF_SPLIT		0x02	/* set if split opcode			*/
#define	PF_REF		0x01	/* set if referenced				*/

/* symbol table and label table entries */

struct sym {
	struct sym	*next;
	word			val;
	byte			used;
	char			name[1];
};

typedef	struct sym *	SYM_PTR;

/* mnemonic table entries */

struct mnementry {
   char mcode[16];
};

struct snementry {
   char mcode[8];
};

struct entry {
	char mnem[16];
};

/* end of dz80.h */

